/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.client;

import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import org.zeith.solarflux.SolarFlux;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.panels.SolarPanels;

public class SolarFluxResourcePack
implements PackResources {
    public final Map<ResourceLocation, IResourceStreamSupplier> resourceMap = new HashMap<ResourceLocation, IResourceStreamSupplier>();
    static SolarFluxResourcePack packInstance;
    private boolean hasInit = false;

    private static IResourceStreamSupplier ofText(String text) {
        return IResourceStreamSupplier.create(() -> true, () -> new ByteArrayInputStream(text.getBytes()));
    }

    private static IResourceStreamSupplier ofFile(File file) {
        return IResourceStreamSupplier.create(file::isFile, () -> new FileInputStream(file));
    }

    public static SolarFluxResourcePack getPackInstance() {
        if (packInstance == null) {
            packInstance = new SolarFluxResourcePack();
        }
        return packInstance;
    }

    public void init() {
        if (this.hasInit) {
            return;
        }
        this.hasInit = true;
        this.resourceMap.clear();
        SolarFlux.JS_MATERIALS.forEach(i -> {
            ResourceLocation reg = i.getRegistryName();
            ResourceLocation models_item = new ResourceLocation(reg.m_135827_(), "models/item/" + reg.m_135815_() + ".json");
            this.resourceMap.put(models_item, SolarFluxResourcePack.ofText("{\"parent\":\"item/generated\",\"textures\":{\"layer0\":\"" + reg.m_135827_() + ":items/materials/" + reg.m_135815_() + "\"}}"));
            File textures = new File(SolarPanels.CONFIG_DIR, "textures");
            File items = new File(textures, "items");
            ResourceLocation textures_items = new ResourceLocation(reg.m_135827_(), "textures/items/materials/" + reg.m_135815_() + ".png");
            this.resourceMap.put(textures_items, SolarFluxResourcePack.ofFile(new File(items, reg.m_135815_() + ".png")));
        });
        SolarPanels.listPanels().forEach(si -> {
            SolarPanelBlock blk = si.getBlock();
            ResourceLocation reg = blk.getRegistryName();
            ResourceLocation blockstate = new ResourceLocation(reg.m_135827_(), "blockstates/" + reg.m_135815_() + ".json");
            ResourceLocation models_block = new ResourceLocation(reg.m_135827_(), "models/block/" + reg.m_135815_() + ".json");
            ResourceLocation models_item = new ResourceLocation(reg.m_135827_(), "models/item/" + reg.m_135815_() + ".json");
            float thicc = si.getPanelData().height * 16.0f;
            float thic2 = thicc + 0.25f;
            float reverseThicc = 16.0f - thicc;
            this.resourceMap.put(blockstate, SolarFluxResourcePack.ofText("{\"variants\":{\"\":{\"model\":\"" + reg.m_135827_() + ":block/" + reg.m_135815_() + "\"}}}"));
            this.resourceMap.put(models_item, SolarFluxResourcePack.ofText("{\"parent\":\"" + reg.m_135827_() + ":block/" + reg.m_135815_() + "\"}"));
            this.resourceMap.put(models_block, SolarFluxResourcePack.ofText("{\"parent\":\"block/block\",\"textures\":{\"0\":\"" + reg.m_135827_() + ":blocks/" + reg.m_135815_() + "_base\",\"1\":\"" + reg.m_135827_() + ":blocks/" + reg.m_135815_() + "_top\",\"particle\":\"solarflux:blocks/example_base\"},\"elements\":[{\"name\":\"base\",\"from\":[0,0,0],\"to\":[16," + thicc + ",16],\"faces\":{\"north\":{\"uv\":[0," + reverseThicc + ",16,16],\"texture\":\"#0\"},\"east\":{\"uv\":[0," + reverseThicc + ",16,16],\"texture\":\"#0\"},\"south\":{\"uv\":[0," + reverseThicc + ",16,16],\"texture\":\"#0\"},\"west\":{\"uv\":[0," + reverseThicc + ",16,16],\"texture\":\"#0\"},\"up\":{\"uv\":[0,0,16,16],\"texture\":\"#1\"},\"down\":{\"uv\":[0,0,16,16],\"texture\":\"#0\"}}},{\"from\":[0," + thicc + ",0],\"to\":[16," + thic2 + ",1],\"faces\":{\"north\":{\"uv\":[0,0,16,0.25],\"texture\":\"#0\"},\"east\":{\"uv\":[0,0,1,0.25],\"texture\":\"#0\"},\"south\":{\"uv\":[0,0,16,0.25],\"texture\":\"#0\"},\"west\":{\"uv\":[0,0,1,0.25],\"texture\":\"#0\"},\"up\":{\"uv\":[0,0,16,1],\"texture\":\"#0\"},\"down\":{\"uv\":[0,0,16,1],\"texture\":\"#0\"}}},{\"from\":[0," + thicc + ",15],\"to\":[16," + thic2 + ",16],\"faces\":{\"north\":{\"uv\":[0,15,16,15.25],\"texture\":\"#0\"},\"east\":{\"uv\":[0,15,1,15.25],\"texture\":\"#0\"},\"south\":{\"uv\":[0,15,16,15.25],\"texture\":\"#0\"},\"west\":{\"uv\":[0,15,1,15.25],\"texture\":\"#0\"},\"up\":{\"uv\":[0,15,16,16],\"texture\":\"#0\"},\"down\":{\"uv\":[0,15,16,16],\"texture\":\"#0\"}}},{\"from\":[0," + thicc + ",1],\"to\":[1," + thic2 + ",15],\"faces\":{\"north\":{\"uv\":[0,0,1,0.25],\"texture\":\"#0\"},\"east\":{\"uv\":[0,0,14,0.25],\"texture\":\"#0\"},\"south\":{\"uv\":[0,0,1,0.25],\"texture\":\"#0\"},\"west\":{\"uv\":[1,0,15,0.25],\"texture\":\"#0\"},\"up\":{\"uv\":[0,1,1,15],\"texture\":\"#0\"},\"down\":{\"uv\":[0,1,1,15],\"texture\":\"#0\"}}},{\"from\":[15," + thicc + ",1],\"to\":[16," + thic2 + ",15],\"faces\":{\"north\":{\"uv\":[15,15,16,15.25],\"texture\":\"#0\"},\"east\":{\"uv\":[1,15,15,15.25],\"texture\":\"#0\"},\"south\":{\"uv\":[0,15,1,15.25],\"texture\":\"#0\"},\"west\":{\"uv\":[1,15,15,15.25],\"texture\":\"#0\"},\"up\":{\"uv\":[15,1,16,15],\"texture\":\"#0\"},\"down\":{\"uv\":[15,1,16,15],\"texture\":\"#0\"}}}]}"));
            if (si.isCustom) {
                File textures = new File(SolarPanels.CONFIG_DIR, "textures");
                File blocks = new File(textures, "blocks");
                ResourceLocation textures_blocks_base = new ResourceLocation(reg.m_135827_(), "textures/blocks/" + reg.m_135815_() + "_base.png");
                ResourceLocation textures_blocks_top = new ResourceLocation(reg.m_135827_(), "textures/blocks/" + reg.m_135815_() + "_top.png");
                ResourceLocation textures_blocks_base_mcmeta = new ResourceLocation(reg.m_135827_(), "textures/blocks/solar_base_" + reg.m_135815_() + "_base.png.mcmeta");
                ResourceLocation textures_blocks_top_mcmeta = new ResourceLocation(reg.m_135827_(), "textures/blocks/solar_top_" + reg.m_135815_() + "_top.png.mcmeta");
                String n = reg.m_135815_().startsWith("sp_custom_") ? reg.m_135815_().substring(10) : reg.m_135815_().substring(3);
                this.resourceMap.put(textures_blocks_base, SolarFluxResourcePack.ofFile(new File(blocks, n + "_base.png")));
                this.resourceMap.put(textures_blocks_base_mcmeta, SolarFluxResourcePack.ofFile(new File(blocks, n + "_base.mcmeta")));
                this.resourceMap.put(textures_blocks_top, SolarFluxResourcePack.ofFile(new File(blocks, n + "_top.png")));
                this.resourceMap.put(textures_blocks_top_mcmeta, SolarFluxResourcePack.ofFile(new File(blocks, n + "_top.mcmeta")));
            }
        });
    }

    public void close() {
    }

    public InputStream m_5542_(String fileName) throws IOException {
        throw new FileNotFoundException(fileName);
    }

    public InputStream m_8031_(PackType type, ResourceLocation location) throws IOException {
        try {
            this.init();
            InputStream in = this.resourceMap.get(location).create();
            return in;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public Collection<ResourceLocation> m_7466_(PackType type, String namespaceIn, String pathIn, int maxDepthIn, Predicate<String> filterIn) {
        return Collections.emptyList();
    }

    public boolean m_7211_(PackType type, ResourceLocation location) {
        this.init();
        IResourceStreamSupplier s = this.resourceMap.get(location);
        return s != null && s.exists();
    }

    public Set<String> m_5698_(PackType type) {
        this.init();
        return Collections.singleton("solarflux");
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) throws IOException {
        if (deserializer.m_7991_().equals("pack")) {
            JsonObject obj = new JsonObject();
            obj.addProperty("pack_format", (Number)8);
            obj.addProperty("description", "Generated resources for SolarFlux");
            return (T)deserializer.m_6322_(obj);
        }
        return null;
    }

    public String m_8017_() {
        return "Solar Flux Generated Resources";
    }

    @FunctionalInterface
    public static interface IIOSupplier<T> {
        public T get() throws IOException;
    }

    public static interface IResourceStreamSupplier {
        public static IResourceStreamSupplier create(final BooleanSupplier exists, final IIOSupplier<InputStream> streamable) {
            return new IResourceStreamSupplier(){

                @Override
                public boolean exists() {
                    return exists.getAsBoolean();
                }

                @Override
                public InputStream create() throws IOException {
                    return (InputStream)streamable.get();
                }
            };
        }

        public boolean exists();

        public InputStream create() throws IOException;
    }
}

